﻿using System;
using Codeplex.OAuth;

namespace Azyobuzi.Twikoto2.Models
{
    class RequestPinCodeEventArgs : EventArgs
    {
        public RequestPinCodeEventArgs(OAuthAuthorizer authorizer, RequestToken requestToken)
        {
            this.RequestToken = requestToken;
            this.AuthorizeUri = authorizer.BuildAuthorizeUrl(
                "https://api.twitter.com/oauth/authorize",
                requestToken);
        }

        public RequestToken RequestToken { private set; get; }
        public string AuthorizeUri { private set; get; }
    }
}
